<?php

namespace App\Modules\Finance\Migrations\Outcome;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Outcome extends Model 
{

    protected $table = 'outcomes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

    public function sourceTreasury()
    {
        return $this->belongsTo('Treasury', 'source_treasury_id');
    }

    public function destinationTreasury()
    {
        return $this->belongsTo('Treasury', 'destination_treasury_id');
    }

    public function systemAccounts()
    {
        return $this->belongsTo('SystemAccounts', 'system_account_id');
    }

}